/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.crafting.pattern.EncodedPatternItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class ItemRendererHooks {
    private static final ThreadLocal<ItemStack> OVERRIDING_FOR = new ThreadLocal();

    private ItemRendererHooks() {
    }

    public static boolean onRenderGuiItemModel(ItemRenderer renderer, ItemStack stack, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (stack.m_41720_() instanceof EncodedPatternItem) {
            EncodedPatternItem encodedPattern;
            ItemStack output;
            if (OVERRIDING_FOR.get() == stack) {
                return false;
            }
            boolean shiftHeld = Screen.m_96638_();
            ClientLevel level = minecraft.f_91073_;
            if (shiftHeld && level != null && !(output = (encodedPattern = (EncodedPatternItem)stack.m_41720_()).getOutput(stack)).m_41619_()) {
                BakedModel realModel = renderer.m_174264_(output, (Level)level, (LivingEntity)minecraft.f_91074_, 0);
                ItemRendererHooks.renderInstead(renderer, output, x, y, realModel);
                return true;
            }
            return false;
        }
        GenericStack unwrapped = GenericStack.unwrapItemStack(stack);
        if (unwrapped != null) {
            AEStackRendering.drawInGui(minecraft, new PoseStack(), x, y, (int)renderer.f_115093_, unwrapped.what());
            if (unwrapped.amount() > 0L) {
                String amtText = unwrapped.what().formatAmount(unwrapped.amount(), AmountFormat.PREVIEW_REGULAR);
                Font font = minecraft.f_91062_;
                StackSizeRenderer.renderSizeLabel(font, x, y, amtText, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderInstead(ItemRenderer renderer, ItemStack stack, int x, int y, BakedModel realModel) {
        OVERRIDING_FOR.set(stack);
        try {
            renderer.m_115127_(stack, x, y, realModel);
        }
        finally {
            OVERRIDING_FOR.remove();
        }
    }
}

